
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables to the model: x1 (knishes) is an integer variable, and x2 (kiwis) is a continuous variable
x1 = m.addVar(vtype=GRB.INTEGER, name="knishes")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="kiwis")

# Set the objective function: Maximize 4*x1 + 8*x2
m.setObjective(4*x1 + 8*x2, GRB.MAXIMIZE)

# Add constraints to the model
m.addConstr(22*x1 + 28*x2 >= 21, "carb_min")
m.addConstr(22*x1 + 28*x2 <= 49, "carb_max")
m.addConstr(14*x1 + 10*x2 >= 40, "calcium_min")
m.addConstr(14*x1 + 10*x2 <= 77, "calcium_max")
m.addConstr(9*x1 - 3*x2 >= 0, "misc_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of knishes: {x1.x}")
    print(f"Number of kiwis: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
