
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    knishes = model.addVar(name="knishes", vtype=gurobi.GRB.INTEGER)
    kiwis = model.addVar(name="kiwis")

    # Objective function: Maximize 4*knishes + 8*kiwis
    model.setObjective(4 * knishes + 8 * kiwis, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(22 * knishes + 28 * kiwis >= 21, name="carb_min")
    model.addConstr(14 * knishes + 10 * kiwis >= 40, name="calcium_min")
    model.addConstr(9 * knishes - 3 * kiwis >= 0, name="knish_kiwi_ratio")
    model.addConstr(22 * knishes + 28 * kiwis <= 49, name="carb_max")
    model.addConstr(14 * knishes + 10 * kiwis <= 77, name="calcium_max")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Knishes: {knishes.varValue}")
        print(f"Kiwis: {kiwis.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
