
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of iron
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1") # milligrams of potassium
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2") # milligrams of vitamin E


    # Set objective function
    m.setObjective(6.91*x0**2 + 9.46*x0*x1 + 8.04*x2**2 + 1.53*x1 + 2.22*x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(9*x0**2 + 7*x2**2 >= 11)
    m.addConstr(1*x1**2 + 7*x2**2 >= 25)
    m.addConstr(9*x0**2 + 1*x1**2 + 7*x2**2 >= 18)
    m.addConstr(9*x0 + 1*x1 + 7*x2 >= 18)
    m.addConstr(11*x0**2 + 9*x1**2 >= 16)
    m.addConstr(11*x0**2 + 11*x2**2 >= 23)
    m.addConstr(9*x1**2 + 11*x2**2 >= 10)
    m.addConstr(11*x0 + 9*x1 + 11*x2 >= 18)
    m.addConstr(-9*x1 + 7*x2 >= 0)
    m.addConstr(2*x0**2 - 4*x1**2 >= 0)
    m.addConstr(9*x0 + 1*x1 <= 44)
    m.addConstr(1*x1**2 + 7*x2**2 <= 66)
    m.addConstr(9*x1 + 11*x2 <= 44)
    m.addConstr(11*x0 + 11*x2 <= 35)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
