
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="milligrams of iron")
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="milligrams of potassium")
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="milligrams of vitamin E")

    # Define the objective function
    model.setObjective(6.91 * x0**2 + 9.46 * x0 * x1 + 8.04 * x2**2 + 1.53 * x1 + 2.22 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(9 * x0 <= 86)
    model.addConstr(11 * x0 <= 76)
    model.addConstr(x1 <= 86)
    model.addConstr(9 * x1 <= 76)
    model.addConstr(7 * x2 <= 86)
    model.addConstr(11 * x2 <= 76)
    model.addConstr(9 * x0**2 + 7 * x2**2 >= 11)
    model.addConstr(x1**2 + 7 * x2**2 >= 25)
    model.addConstr(9 * x0**2 + x1**2 + 7 * x2**2 >= 18)
    model.addConstr(9 * x0 + x1 + 7 * x2 >= 18)
    model.addConstr(11 * x0**2 + 9 * x1**2 >= 16)
    model.addConstr(11 * x0**2 + 11 * x2**2 >= 23)
    model.addConstr(9 * x1**2 + 11 * x2**2 >= 10)
    model.addConstr(11 * x0 + 9 * x1 + 11 * x2 >= 18)
    model.addConstr(-9 * x1 + 7 * x2 >= 0)
    model.addConstr(2 * x0**2 - 4 * x1**2 >= 0)
    model.addConstr(9 * x0 + x1 <= 44)
    model.addConstr(x1**2 + 7 * x2**2 <= 66)
    model.addConstr(9 * x1 + 11 * x2 <= 44)
    model.addConstr(11 * x0 + 11 * x2 <= 35)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print("Milligrams of iron: ", x0.varValue)
        print("Milligrams of potassium: ", x1.varValue)
        print("Milligrams of vitamin E: ", x2.varValue)
        print("Objective function value: ", model.objVal)
    else:
        print("No optimal solution found.")

solve_optimization_problem()
