
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("resource_allocation")

    # Create variables
    x = m.addVars(4, lb=0, vtype=gp.GRB.CONTINUOUS, name=["Bill", "Hank", "Bobby", "John"])


    # Set objective function
    m.setObjective(9*x[0] + 3*x[1] + 2*x[2] + 2*x[3], gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(6*x[0] + 6*x[1] + 11*x[3] >= 31)
    m.addConstr(6*x[0] + 6*x[1] + 7*x[2] >= 31)
    m.addConstr(6*x[0] + 6*x[1] + 11*x[3] >= 37)
    m.addConstr(6*x[0] + 6*x[1] + 7*x[2] >= 37)
    m.addConstr(9*x[1] + 18*x[2] >= 17)
    m.addConstr(9*x[1] + 12*x[3] >= 20)
    m.addConstr(8*x[0] + 9*x[1] >= 27)
    m.addConstr(18*x[2] + 12*x[3] >= 19)
    m.addConstr(7*x[0] + 1*x[2] + 13*x[3] >= 26)
    m.addConstr(7*x[0] + 4*x[1] + 1*x[2] >= 26)
    m.addConstr(7*x[0] + 1*x[2] + 13*x[3] >= 27)
    m.addConstr(7*x[0] + 4*x[1] + 1*x[2] >= 27)
    m.addConstr(7*x[2] + 11*x[3] <= 99)
    m.addConstr(6*x[0] + 11*x[3] <= 52)
    m.addConstr(6*x[0] + 7*x[2] <= 118)
    m.addConstr(6*x[0] + 7*x[2] + 11*x[3] <= 60)
    m.addConstr(6*x[0] + 6*x[1] + 7*x[2] + 11*x[3] <= 60)
    m.addConstr(8*x[0] + 18*x[2] <= 104)
    m.addConstr(9*x[1] + 18*x[2] <= 63)
    m.addConstr(8*x[0] + 12*x[3] <= 34)
    m.addConstr(8*x[0] + 9*x[1] <= 72)
    m.addConstr(8*x[0] + 9*x[1] + 18*x[2] + 12*x[3] <= 72)
    m.addConstr(7*x[0] + 4*x[1] <= 64)
    m.addConstr(7*x[0] + 1*x[2] <= 71)
    m.addConstr(7*x[0] + 13*x[3] <= 106)
    m.addConstr(4*x[1] + 13*x[3] <= 29)
    m.addConstr(7*x[0] + 4*x[1] + 1*x[2] + 13*x[3] <= 29)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
        print('Obj: %g' % m.objVal)
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
