
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="x0", lb=0)  # hours worked by Bill
    x1 = model.addVar(name="x1", lb=0)  # hours worked by Hank
    x2 = model.addVar(name="x2", lb=0)  # hours worked by Bobby
    x3 = model.addVar(name="x3", lb=0)  # hours worked by John

    # Define the objective function
    model.setObjective(9 * x0 + 3 * x1 + 2 * x2 + 2 * x3, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(6 * x0 >= 31)  
    model.addConstr(6 * x0 + 7 * x2 >= 31)  
    model.addConstr(6 * x0 + 6 * x1 + 11 * x3 >= 37)  
    model.addConstr(6 * x0 + 6 * x1 + 7 * x2 >= 37)  
    model.addConstr(9 * x1 + 18 * x2 >= 17)  
    model.addConstr(9 * x1 + 12 * x3 >= 20)  
    model.addConstr(8 * x0 + 9 * x1 >= 27)  
    model.addConstr(18 * x2 + 12 * x3 >= 19)  
    model.addConstr(7 * x0 + x2 + 13 * x3 >= 26)  
    model.addConstr(7 * x0 + 4 * x1 + x2 >= 26)  
    model.addConstr(7 * x0 + x2 + 13 * x3 >= 27)  
    model.addConstr(7 * x0 + 4 * x1 + x2 >= 27)  
    model.addConstr(7 * x2 + 11 * x3 <= 99)  
    model.addConstr(6 * x0 + 11 * x3 <= 52)  
    model.addConstr(6 * x0 + 7 * x2 <= 118)  
    model.addConstr(6 * x0 + 7 * x2 + 11 * x3 <= 60)  
    model.addConstr(6 * x0 + 6 * x1 + 7 * x2 + 11 * x3 <= 60)  
    model.addConstr(8 * x0 + 18 * x2 <= 104)  
    model.addConstr(9 * x1 + 18 * x2 <= 63)  
    model.addConstr(8 * x0 + 12 * x3 <= 34)  
    model.addConstr(8 * x0 + 9 * x1 <= 72)  
    model.addConstr(8 * x0 + 9 * x1 + 18 * x2 + 12 * x3 <= 72)  
    model.addConstr(7 * x0 + 4 * x1 <= 64)  
    model.addConstr(7 * x0 + x2 <= 71)  
    model.addConstr(7 * x0 + 13 * x3 <= 106)  
    model.addConstr(4 * x1 + 13 * x3 <= 29)  
    model.addConstr(7 * x0 + 4 * x1 + x2 + 13 * x3 <= 29)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Hours worked by Bill: ", x0.varValue)
        print("Hours worked by Hank: ", x1.varValue)
        print("Hours worked by Bobby: ", x2.varValue)
        print("Hours worked by John: ", x3.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
