
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    ham_sandwiches = m.addVar(lb=0, name="ham_sandwiches")
    blueberry_pies = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="blueberry_pies")


    # Set objective function
    m.setObjective(3.97 * ham_sandwiches + 1.71 * blueberry_pies, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(4.09 * ham_sandwiches + 3.56 * blueberry_pies >= 79, "carbohydrates_min")
    m.addConstr(3.68 * ham_sandwiches + 0.65 * blueberry_pies >= 73, "fat_min")
    m.addConstr(5.03 * ham_sandwiches + 5.33 * blueberry_pies >= 57, "tastiness_min")
    m.addConstr(-8 * ham_sandwiches + 7 * blueberry_pies >= 0, "sandwich_pie_ratio")
    m.addConstr(4.09 * ham_sandwiches + 3.56 * blueberry_pies <= 227, "carbohydrates_max")
    m.addConstr(3.68 * ham_sandwiches + 0.65 * blueberry_pies <= 120, "fat_max")
    m.addConstr(5.03 * ham_sandwiches + 5.33 * blueberry_pies <= 173, "tastiness_max")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('ham_sandwiches: %g' % ham_sandwiches.x)
        print('blueberry_pies: %g' % blueberry_pies.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
