
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="ham_sandwiches", lb=0)  # Ham sandwiches
    x2 = model.addVar(name="blueberry_pies", lb=0, integrality=1)  # Blueberry pies

    # Define the objective function
    model.setObjective(3.97 * x1 + 1.71 * x2, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(4.09 * x1 + 3.56 * x2 >= 79, name="carbohydrates_min")
    model.addConstr(3.68 * x1 + 0.65 * x2 >= 73, name="fat_min")
    model.addConstr(5.03 * x1 + 5.33 * x2 >= 57, name="tastiness_min")
    model.addConstr(-8 * x1 + 7 * x2 >= 0, name="relationship")
    model.addConstr(4.09 * x1 + 3.56 * x2 <= 227, name="carbohydrates_max")
    model.addConstr(3.68 * x1 + 0.65 * x2 <= 120, name="fat_max")
    model.addConstr(5.03 * x1 + 5.33 * x2 <= 173, name="tastiness_max")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Ham sandwiches: {x1.varValue}")
        print(f"Blueberry pies: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
