
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
tomato_vines = m.addVar(vtype=gp.GRB.INTEGER, name="tomato_vines")
orange_trees = m.addVar(vtype=gp.GRB.INTEGER, name="orange_trees")
chrysanthemums = m.addVar(vtype=gp.GRB.INTEGER, name="chrysanthemums")
apple_trees = m.addVar(vtype=gp.GRB.INTEGER, name="apple_trees")


# Set objective function
m.setObjective(8 * tomato_vines + 2 * orange_trees + 7 * chrysanthemums + 7 * apple_trees, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(10 * orange_trees + 9 * chrysanthemums >= 14)
m.addConstr(3 * orange_trees + 4 * chrysanthemums + 8 * apple_trees >= 24)
m.addConstr(8 * tomato_vines + 4 * chrysanthemums + 8 * apple_trees >= 24)
m.addConstr(8 * tomato_vines + 3 * orange_trees + 8 * apple_trees >= 24)
m.addConstr(3 * orange_trees + 4 * chrysanthemums + 8 * apple_trees >= 30)
m.addConstr(8 * tomato_vines + 4 * chrysanthemums + 8 * apple_trees >= 30)
m.addConstr(8 * tomato_vines + 3 * orange_trees + 8 * apple_trees >= 30)
m.addConstr(3 * orange_trees + 4 * chrysanthemums + 8 * apple_trees >= 33)
m.addConstr(8 * tomato_vines + 4 * chrysanthemums + 8 * apple_trees >= 33)
m.addConstr(8 * tomato_vines + 3 * orange_trees + 8 * apple_trees >= 33)
m.addConstr(8 * tomato_vines + 9 * chrysanthemums <= 49)
m.addConstr(9 * chrysanthemums + 4 * apple_trees <= 48)
m.addConstr(10 * orange_trees + 4 * apple_trees <= 20)
m.addConstr(8 * tomato_vines + 10 * orange_trees <= 66)
m.addConstr(8 * tomato_vines + 4 * apple_trees <= 55)
m.addConstr(10 * orange_trees + 9 * chrysanthemums + 4 * apple_trees <= 45)
m.addConstr(8 * tomato_vines + 10 * orange_trees + 9 * chrysanthemums + 4 * apple_trees <= 27)
m.addConstr(3 * orange_trees + 4 * chrysanthemums <= 111)
m.addConstr(4 * chrysanthemums + 8 * apple_trees <= 49)
m.addConstr(8 * tomato_vines + 3 * orange_trees <= 64)
m.addConstr(3 * orange_trees + 8 * apple_trees <= 51)
m.addConstr(8 * tomato_vines + 4 * chrysanthemums <= 137)
m.addConstr(8 * tomato_vines + 3 * orange_trees + 4 * chrysanthemums <= 36)
m.addConstr(8 * tomato_vines + 4 * chrysanthemums + 8 * apple_trees <= 63)
m.addConstr(8 * tomato_vines + 3 * orange_trees + 4 * chrysanthemums + 8 * apple_trees <= 63)
m.addConstr(8 * tomato_vines <= 69)
m.addConstr(8 * tomato_vines + 3 * orange_trees + 4 * chrysanthemums + 8 * apple_trees <= 140)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

