
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    vitamin_k = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_k")
    vitamin_a = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_a")


    # Set objective function
    m.setObjective(9 * vitamin_k + 2 * vitamin_a, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(2 * vitamin_k + 15 * vitamin_a >= 62, "c1")
    m.addConstr(7 * vitamin_k + 11 * vitamin_a >= 74, "c2")
    m.addConstr(5 * vitamin_k + 8 * vitamin_a >= 11, "c3")
    m.addConstr(2 * vitamin_k + 8 * vitamin_a >= 34, "c4")
    m.addConstr(-4 * vitamin_k + 5 * vitamin_a >= 0, "c5")
    m.addConstr(2 * vitamin_k + 15 * vitamin_a <= 82, "c6")
    m.addConstr(7 * vitamin_k + 11 * vitamin_a <= 111, "c7")
    m.addConstr(5 * vitamin_k + 8 * vitamin_a <= 49, "c8")
    m.addConstr(2 * vitamin_k + 8 * vitamin_a <= 98, "c9")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('vitamin_k: %g' % vitamin_k.x)
        print('vitamin_a: %g' % vitamin_a.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GrorbiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
