
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="milligrams_of_vitamin_K", lb=0)  # Assuming non-negative
    x1 = model.addVar(name="milligrams_of_vitamin_A", lb=0)  # Assuming non-negative

    # Define the objective function
    model.setObjective(9 * x0 + 2 * x1, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(2 * x0 + 15 * x1 >= 62)
    model.addConstr(7 * x0 + 11 * x1 >= 74)
    model.addConstr(5 * x0 + 8 * x1 >= 11)
    model.addConstr(2 * x0 + 8 * x1 >= 34)
    model.addConstr(-4 * x0 + 5 * x1 >= 0)
    model.addConstr(2 * x0 + 15 * x1 <= 82)
    model.addConstr(7 * x0 + 11 * x1 <= 111)
    model.addConstr(5 * x0 + 8 * x1 <= 49)
    model.addConstr(2 * x0 + 8 * x1 <= 98)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin K: {x0.varValue}")
        print(f"Milligrams of vitamin A: {x1.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
