
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
cheeseburgers = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cheeseburgers")
lemons = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="lemons")
strips_of_bacon = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="strips_of_bacon")
hot_dogs = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="hot_dogs")

# Set objective function
m.setObjective(9.28 * cheeseburgers + 9.53 * lemons + 1.87 * strips_of_bacon + 8.04 * hot_dogs, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(8 * cheeseburgers + 3 * hot_dogs >= 6)
m.addConstr(6 * lemons + 3 * hot_dogs >= 10)
m.addConstr(8 * cheeseburgers + 6 * lemons >= 15)
m.addConstr(8 * cheeseburgers + 6 * lemons + 4 * strips_of_bacon + 3 * hot_dogs >= 15)
m.addConstr(3 * lemons + 3 * hot_dogs >= 11)
m.addConstr(3 * lemons + 5 * strips_of_bacon >= 4)
m.addConstr(5 * strips_of_bacon + 3 * hot_dogs >= 13)
m.addConstr(1 * cheeseburgers + 3 * hot_dogs >= 7)
m.addConstr(1 * cheeseburgers + 5 * strips_of_bacon + 3 * hot_dogs >= 13)
m.addConstr(1 * cheeseburgers + 3 * lemons + 5 * strips_of_bacon + 3 * hot_dogs >= 13)
m.addConstr(3 * lemons + 7 * hot_dogs >= 9)
m.addConstr(3 * strips_of_bacon + 7 * hot_dogs >= 11)
m.addConstr(3 * cheeseburgers + 7 * hot_dogs >= 5)
m.addConstr(3 * cheeseburgers + 3 * strips_of_bacon >= 12)
m.addConstr(3 * cheeseburgers + 3 * strips_of_bacon + 7 * hot_dogs >= 9)
m.addConstr(3 * lemons + 3 * strips_of_bacon + 7 * hot_dogs >= 9)
m.addConstr(3 * cheeseburgers + 3 * strips_of_bacon + 7 * hot_dogs >= 12)
m.addConstr(3 * lemons + 3 * strips_of_bacon + 7 * hot_dogs >= 12)
m.addConstr(3 * cheeseburgers + 3 * lemons + 3 * strips_of_bacon + 7 * hot_dogs >= 12)
m.addConstr(4 * strips_of_bacon - 6 * hot_dogs >= 0)
m.addConstr(8 * cheeseburgers + 6 * lemons <= 40)
m.addConstr(6 * lemons + 4 * strips_of_bacon <= 32)
m.addConstr(8 * cheeseburgers + 4 * strips_of_bacon <= 57)
m.addConstr(8 * cheeseburgers + 3 * hot_dogs <= 52)
m.addConstr(6 * lemons + 3 * hot_dogs <= 25)
m.addConstr(8 * cheeseburgers + 6 * lemons + 4 * strips_of_bacon <= 54)
m.addConstr(8 * cheeseburgers + 4 * strips_of_bacon + 3 * hot_dogs <= 67)
m.addConstr(8 * cheeseburgers + 6 * lemons + 3 * hot_dogs <= 34)
m.addConstr(1 * cheeseburgers + 5 * strips_of_bacon + 3 * hot_dogs <= 39)
m.addConstr(3 * lemons + 7 * hot_dogs <= 18)
m.addConstr(3 * cheeseburgers + 3 * lemons + 7 * hot_dogs <= 38)
m.addConstr(3 * lemons + 3 * strips_of_bacon + 7 * hot_dogs <= 20)
m.addConstr(3 * cheeseburgers + 3 * strips_of_bacon + 7 * hot_dogs <= 37)


m.addConstr(8 * cheeseburgers + 6 * lemons + 4 * strips_of_bacon + 3 * hot_dogs <= 70)
m.addConstr(1 * cheeseburgers + 3 * lemons + 5 * strips_of_bacon + 3 * hot_dogs <= 53)
m.addConstr(3 * cheeseburgers + 3 * lemons + 3 * strips_of_bacon + 7 * hot_dogs <= 58)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

