
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="cheeseburgers", lb=0, ub=gurobi.GRB.INFINITY)
    x1 = model.addVar(name="lemons", lb=0, ub=gurobi.GRB.INFINITY, integrality=1)
    x2 = model.addVar(name="strips of bacon", lb=0, ub=gurobi.GRB.INFINITY, integrality=1)
    x3 = model.addVar(name="hot dogs", lb=0, ub=gurobi.GRB.INFINITY, integrality=1)

    # Objective function
    model.setObjective(9.28*x0 + 9.53*x1 + 1.87*x2 + 8.04*x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(8*x0 + 6*x1 + 4*x2 + 3*x3 <= 70)
    model.addConstr(x0 + 3*x1 + 5*x2 + 3*x3 <= 53)
    model.addConstr(3*x0 + 3*x1 + 3*x2 + 7*x3 <= 58)
    model.addConstr(8*x0 + 3*x3 >= 6)
    model.addConstr(6*x1 + 3*x3 >= 10)
    model.addConstr(8*x0 + 6*x1 >= 15)
    model.addConstr(8*x0 + 6*x1 + 4*x2 + 3*x3 >= 15)
    model.addConstr(3*x1 + 3*x3 >= 11)
    model.addConstr(3*x1 + 5*x2 >= 4)
    model.addConstr(5*x2 + 3*x3 >= 13)
    model.addConstr(x0 + 3*x3 >= 7)
    model.addConstr(x0 + 5*x2 + 3*x3 >= 13)
    model.addConstr(x0 + 3*x1 + 5*x2 + 3*x3 >= 13)
    model.addConstr(3*x1 + 7*x3 >= 9)
    model.addConstr(3*x2 + 7*x3 >= 11)
    model.addConstr(3*x0 + 7*x3 >= 5)
    model.addConstr(3*x0 + 3*x2 >= 12)
    model.addConstr(3*x0 + 3*x2 + 7*x3 >= 9)
    model.addConstr(3*x1 + 3*x2 + 7*x3 >= 9)
    model.addConstr(3*x0 + 3*x2 + 7*x3 >= 12)
    model.addConstr(3*x1 + 3*x2 + 7*x3 >= 12)
    model.addConstr(3*x0 + 3*x1 + 3*x2 + 7*x3 >= 12)
    model.addConstr(6*x2 - 6*x3 >= 0)
    model.addConstr(8*x0 + 6*x1 <= 40)
    model.addConstr(6*x1 + 4*x2 <= 32)
    model.addConstr(8*x0 + 4*x2 <= 57)
    model.addConstr(8*x0 + 3*x3 <= 52)
    model.addConstr(6*x1 + 3*x3 <= 25)
    model.addConstr(8*x0 + 6*x1 + 4*x2 <= 54)
    model.addConstr(8*x0 + 4*x2 + 3*x3 <= 67)
    model.addConstr(8*x0 + 6*x1 + 3*x3 <= 34)
    model.addConstr(x0 + 5*x2 + 3*x3 <= 39)
    model.addConstr(3*x1 + 7*x3 <= 18)
    model.addConstr(3*x0 + 3*x1 + 7*x3 <= 38)
    model.addConstr(3*x1 + 3*x2 + 7*x3 <= 20)
    model.addConstr(3*x0 + 3*x2 + 7*x3 <= 37)

    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Cheeseburgers: ", x0.varValue)
        print("Lemons: ", x1.varValue)
        print("Strips of bacon: ", x2.varValue)
        print("Hot dogs: ", x3.varValue)
    else:
        print("No solution found")

solve_optimization_problem()
