
from gurobipy import Model, GRB

# Create a new model
m = Model("optimization_problem")

# Create variables
variables = {
    'security onions': m.addVar(vtype=GRB.INTEGER, name='security_onions'),
    'automatic alerts': m.addVar(vtype=GRB.INTEGER, name='automatic_alerts'),
    'network administrators': m.addVar(vtype=GRB.INTEGER, name='network_administrators'),
    'SOC operators': m.addVar(vtype=GRB.INTEGER, name='SOC_operators'),
    'honeypots': m.addVar(vtype=GRB.INTEGER, name='honeypots'),
    'deployed decoys': m.addVar(vtype=GRB.INTEGER, name='deployed_decoys'),
    'patches per day': m.addVar(vtype=GRB.INTEGER, name='patches_per_day')
}


# Set objective function
m.setObjective(2.94 * variables['security onions'] + 9.55 * variables['automatic alerts'] + 4.4 * variables['network administrators'] + 7.52 * variables['SOC operators'] + 9.96 * variables['honeypots'] + 4.12 * variables['deployed decoys'] + 7.42 * variables['patches per day'], GRB.MINIMIZE)

# Add constraints
impact = {'security onions': 5.55, 'automatic alerts': 5.44, 'network administrators': 0.37, 'SOC operators': 6.6, 'honeypots': 3.38, 'deployed decoys': 2.14, 'patches per day': 1.9}

m.addConstr(sum([impact[var_name] * variables[var_name] for var_name in impact]) <= 259, "r0_upper_bound")


constraints_vars = [
    (['network administrators', 'deployed decoys'], 17),
    (['automatic alerts', 'network administrators'], 24),
    (['SOC operators', 'deployed decoys'], 32),
    (['security onions', 'automatic alerts'], 24),
    (['security onions', 'honeypots', 'deployed decoys'], 33),
    (['network administrators', 'SOC operators', 'honeypots'], 33),
    (['network administrators', 'deployed decoys', 'patches per day'], 33),
    (['SOC operators', 'honeypots', 'deployed decoys'], 33),
    (['automatic alerts', 'SOC operators', 'honeypots'], 33),
    (['automatic alerts', 'SOC operators', 'deployed decoys'], 33),
    (['network administrators', 'SOC operators', 'patches per day'], 33),
    (['security onions', 'automatic alerts', 'network administrators'], 33),
    (['security onions', 'automatic alerts', 'honeypots'], 33),
    (['security onions', 'SOC operators', 'patches per day'], 33),
    (['security onions', 'network administrators', 'patches per day'], 33),
    (['automatic alerts', 'network administrators', 'SOC operators'], 33),
    (['security onions', 'network administrators', 'honeypots'], 33),
    (['security onions', 'network administrators', 'SOC operators'], 33),
    (['security onions', 'automatic alerts', 'SOC operators'], 33),
    (['SOC operators', 'honeypots', 'patches per day'], 33),
    (['automatic alerts', 'network administrators', 'deployed decoys'], 33),
    (['network administrators', 'honeypots', 'patches per day'], 33),
     (['security onions', 'honeypots', 'deployed decoys'], 24), # Example: Total impact from x, y, and z must be at least 24
]

for var_names, lower_bound in constraints_vars:
    m.addConstr(sum([impact[var_name] * variables[var_name] for var_name in var_names]) >= lower_bound)

m.addConstr(-1 * variables['automatic alerts'] + 4 * variables['patches per day'] >= 0)
m.addConstr(impact['automatic alerts'] * variables['automatic alerts'] + impact['network administrators'] * variables['network administrators'] + impact['honeypots'] * variables['honeypots'] <= 160)
m.addConstr(impact['honeypots'] * variables['honeypots'] + impact['deployed decoys'] * variables['deployed decoys'] + impact['patches per day'] * variables['patches per day'] <= 50)
m.addConstr(impact['security onions'] * variables['security onions'] + impact['network administrators'] * variables['network administrators'] + impact['patches per day'] * variables['patches per day'] <= 116)
m.addConstr(impact['security onions'] * variables['security onions'] + impact['SOC operators'] * variables['SOC operators'] + impact['deployed decoys'] * variables['deployed decoys'] <= 203)
m.addConstr(impact['automatic alerts'] * variables['automatic alerts'] + impact['SOC operators'] * variables['SOC operators'] + impact['patches per day'] * variables['patches per day'] <= 241)
m.addConstr(impact['automatic alerts'] * variables['automatic alerts'] + impact['deployed decoys'] * variables['deployed decoys'] + impact['patches per day'] * variables['patches per day'] <= 259)
m.addConstr(impact['network administrators'] * variables['network administrators'] + impact['SOC operators'] * variables['SOC operators'] + impact['honeypots'] * variables['honeypots'] <= 88)
m.addConstr(impact['security onions'] * variables['security onions'] + impact['automatic alerts'] * variables['automatic alerts'] + impact['network administrators'] * variables['network administrators'] <= 211)
m.addConstr(impact['security onions'] * variables['security onions'] + impact['SOC operators'] * variables['SOC operators'] + impact['honeypots'] * variables['honeypots'] <= 177)
m.addConstr(impact['automatic alerts'] * variables['automatic alerts'] + impact['honeypots'] * variables['honeypots'] + impact['patches per day'] * variables['patches per day'] <= 201)
m.addConstr(impact['network administrators'] * variables['network administrators'] + impact['SOC operators'] * variables['SOC operators'] + impact['deployed decoys'] * variables['deployed decoys'] <= 80)



# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

