
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of vitamin B3
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1") # milligrams of vitamin B6
x2 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="x2") # milligrams of vitamin B9
x3 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="x3") # milligrams of vitamin B5


# Set objective function
m.setObjective(3*x0**2 + 2*x0*x2 + 7*x0*x3 + x1**2 + 7*x1*x3 + x2**2 + 4*x2*x3 + 3*x3**2 + 3*x0 + 3*x1 + 7*x2 + 6*x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(4*x1 + 19*x3 >= 19)
m.addConstr(4*x1**2 + 2*x2**2 >= 13)
m.addConstr(9*x0 + 4*x1 >= 11)
m.addConstr(9*x0 + 19*x3 >= 18)
m.addConstr(4*x1 + 2*x2 + 19*x3 >= 25)
m.addConstr(9*x0 + 2*x2 + 19*x3 >= 25)
m.addConstr(9*x0 + 4*x1 + 19*x3 >= 25)
m.addConstr(4*x1 + 2*x2 + 19*x3 >= 21)
m.addConstr(9*x0 + 2*x2 + 19*x3 >= 21)
m.addConstr(9*x0 + 4*x1 + 19*x3 >= 21)
m.addConstr(4*x1 + 2*x2 + 19*x3 >= 23)
m.addConstr(9*x0 + 2*x2 + 19*x3 >= 23)
m.addConstr(9*x0 + 4*x1 + 19*x3 >= 23)
m.addConstr(9*x0 + 4*x1 + 2*x2 + 19*x3 >= 23)
m.addConstr(9*x0**2 - 7*x3**2 >= 0)
m.addConstr(8*x0 - 8*x1 >= 0)
m.addConstr(9*x0 + 2*x2 <= 59)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

