
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x1")  # milligrams of vitamin B3
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x2")  # milligrams of vitamin B6
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x3", vtype=gurobi.GRB.INTEGER)  # milligrams of vitamin B9
    x4 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x4", vtype=gurobi.GRB.INTEGER)  # milligrams of vitamin B5

    # Objective function
    model.setObjective(3*x1**2 + 2*x1*x3 + 7*x1*x4 + x2**2 + 7*x2*x4 + x3**2 + 4*x3*x4 + 3*x4**2 + 3*x1 + 3*x2 + 7*x3 + 6*x4, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(9*x1 <= 118)
    model.addConstr(4*x2 <= 118)
    model.addConstr(2*x3 <= 118)
    model.addConstr(19*x4 <= 118)
    model.addConstr(4*x2 + 19*x4 >= 19)
    model.addConstr(16*x2**2 + 4*x3**2 >= 13)
    model.addConstr(9*x1 + 4*x2 >= 11)
    model.addConstr(9*x1 + 19*x4 >= 18)
    model.addConstr(9*x1 + 4*x2 + 19*x4 >= 25)
    model.addConstr(9*x1 + 2*x3 + 19*x4 >= 25)
    model.addConstr(9*x1 + 4*x2 + 19*x4 >= 21)
    model.addConstr(4*x2 + 2*x3 + 19*x4 >= 23)
    model.addConstr(9*x1 + 2*x3 + 19*x4 >= 23)
    model.addConstr(9*x1 + 4*x2 + 19*x4 >= 23)
    model.addConstr(9*x1 + 4*x2 + 2*x3 + 19*x4 >= 23)
    model.addConstr(81*x1**2 - 7*x4**2 >= 0)
    model.addConstr(8*x1 - 8*x2 >= 0)
    model.addConstr(9*x1 + 2*x3 <= 59)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Objective: ", model.objVal)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
        print("x4: ", x4.varValue)
    else:
        print("No solution found")

solve_optimization_problem()
