
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("minimize_likelihood_to_quit")

    # Create variables
    x0 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x0") # hours worked by Jean
    x1 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x1") # hours worked by George
    x2 = model.addVar(vtype=gp.GRB.INTEGER, name="x2") # hours worked by Bill


    # Set objective function
    model.setObjective(7.52 * x0 + 9.79 * x1 + 6.1 * x2, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(3 * x0 + 8 * x2 >= 14, "c1")
    model.addConstr(2 * x1 + 8 * x2 >= 19, "c2")
    model.addConstr(3 * x0 + 2 * x1 >= 13, "c3")
    model.addConstr(3 * x0 + 2 * x1 + 8 * x2 >= 22, "c4")
    model.addConstr(9 * x0 - 3 * x2 >= 0, "c5")
    model.addConstr(7 * x0 - 2 * x1 >= 0, "c6")
    model.addConstr(2 * x1 + 8 * x2 <= 48, "c7")
    model.addConstr(3 * x0 + 8 * x2 <= 38, "c8")


    # Optimize model
    model.optimize()

    # Print solution
    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('x0: %g' % x0.x)
        print('x1: %g' % x1.x)
        print('x2: %g' % x2.x)
    elif model.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
