
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="hours_worked_by_Jean", lb=0)  # Non-negative
    x2 = model.addVar(name="hours_worked_by_George", lb=0)  # Non-negative
    x3 = model.addVar(name="hours_worked_by_Bill", lb=0, vtype=gurobi.GRB.INTEGER)  # Non-negative integer

    # Objective function
    model.setObjective(7.52 * x1 + 9.79 * x2 + 6.1 * x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(3 * x1 + 8 * x3 >= 14)
    model.addConstr(2 * x2 + 8 * x3 >= 19)
    model.addConstr(3 * x1 + 2 * x2 >= 13)
    model.addConstr(3 * x1 + 2 * x2 + 8 * x3 >= 22)
    model.addConstr(9 * x1 - 3 * x3 >= 0)
    model.addConstr(7 * x1 - 2 * x2 >= 0)
    model.addConstr(2 * x2 + 8 * x3 <= 48)
    model.addConstr(3 * x1 + 8 * x3 <= 38)

    # Solve the model
    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Jean: {x1.varValue}")
        print(f"Hours worked by George: {x2.varValue}")
        print(f"Hours worked by Bill: {x3.varValue}")
        print(f"Objective: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_optimization_problem()
