
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(7, vtype=GRB.INTEGER, name=["paper clips", "smoke detectors", "office chairs", "yellow highlighters", "lanyards", "red pens", "hole punches"])


# Set objective function
m.setObjective(3*x[0] + 3*x[1] + 3*x[2] + 1*x[3] + 3*x[4] + 4*x[5] + 4*x[6], GRB.MINIMIZE)

# Add weight constraint
m.addConstr(5*x[0] + 18*x[1] + 17*x[2] + 14*x[3] + 7*x[4] + 1*x[5] + 19*x[6] <= 824, "weight")

# Add storage space constraint
m.addConstr(5*x[0] + 10*x[1] + 2*x[2] + 7*x[3] + 7*x[4] + 12*x[5] + 10*x[6] <= 496, "storage")

# Add other constraints
m.addConstr(14*x[3] + x[5] >= 48)
m.addConstr(14*x[3] + 19*x[6] >= 45)
m.addConstr(5*x[0] + 17*x[2] >= 59)
m.addConstr(5*x[0] + 14*x[3] >= 76)
m.addConstr(18*x[1] + 19*x[6] >= 76)
m.addConstr(5*x[0] + 18*x[1] >= 73)
m.addConstr(18*x[1] + 14*x[3] >= 55)
m.addConstr(5*x[0] + 7*x[4] >= 49)
m.addConstr(x[5] + 19*x[6] >= 98)
m.addConstr(7*x[4] + x[5] >= 116)
m.addConstr(17*x[2] + 19*x[6] >= 115)
m.addConstr(17*x[2] + 14*x[3] >= 107)
m.addConstr(14*x[3] + 7*x[4] + x[5] >= 102)
m.addConstr(17*x[2] + 14*x[3] + 7*x[4] >= 102)
m.addConstr(18*x[1] + 7*x[4] + x[5] >= 102)
m.addConstr(5*x[0] + 7*x[4] + x[5] >= 102)
m.addConstr(5*x[0] + 14*x[3] + x[5] >= 102)
# ... (add all other constraints similarly)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Obj: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

