
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("Resource_Allocation")

    # Create variables
    george = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="George")
    peggy = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Peggy")
    mary = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Mary")


    # Set objective function
    model.setObjective(1.57 * george + 7.49 * peggy + 9.9 * mary, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(4 * george + 11 * peggy >= 15, "c1")
    model.addConstr(6 * george + 1 * peggy >= 51, "c2")
    model.addConstr(11 * george + 8 * peggy >= 13, "c3")
    model.addConstr(11 * george + 14 * mary >= 20, "c4")
    model.addConstr(3 * george + 6 * mary >= 38, "c5")
    model.addConstr(11 * peggy + 5 * mary <= 129, "c6")
    model.addConstr(4 * george + 11 * peggy <= 49, "c7")
    model.addConstr(4 * george + 11 * peggy + 5 * mary <= 49, "c8")
    model.addConstr(6 * george + 4 * mary <= 189, "c9")
    model.addConstr(6 * george + 1 * peggy <= 165, "c10")
    model.addConstr(6 * george + 1 * peggy + 4 * mary <= 212, "c11")
    model.addConstr(11 * george + 14 * mary <= 100, "c12")
    model.addConstr(11 * george + 8 * peggy <= 62, "c13")
    model.addConstr(8 * peggy + 14 * mary <= 79, "c14")
    model.addConstr(11 * george + 8 * peggy + 14 * mary <= 79, "c15")
    model.addConstr(1 * peggy + 6 * mary <= 117, "c16")
    model.addConstr(3 * george + 6 * mary <= 45, "c17")
    model.addConstr(3 * george + 1 * peggy + 6 * mary <= 45, "c18")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
