
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="x0", lb=0)  # hours worked by George
    x1 = model.addVar(name="x1", lb=0)  # hours worked by Peggy
    x2 = model.addVar(name="x2", lb=0)  # hours worked by Mary

    # Define the objective function
    model.setObjective(1.57 * x0 + 7.49 * x1 + 9.9 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(4 * x0 + 11 * x1 + 5 * x2 <= 136)
    model.addConstr(6 * x0 + x1 + 4 * x2 <= 235)
    model.addConstr(11 * x0 + 8 * x1 + 14 * x2 <= 123)
    model.addConstr(3 * x0 + x1 + 6 * x2 <= 135)
    model.addConstr(4 * x0 + 11 * x1 >= 15)
    model.addConstr(6 * x0 + x1 >= 51)
    model.addConstr(11 * x0 + 8 * x1 >= 13)
    model.addConstr(11 * x0 + 14 * x2 >= 20)
    model.addConstr(3 * x0 + 6 * x2 >= 38)
    model.addConstr(11 * x1 + 5 * x2 <= 129)
    model.addConstr(4 * x0 + 11 * x1 <= 49)
    model.addConstr(4 * x0 + 11 * x1 + 5 * x2 <= 49)
    model.addConstr(6 * x0 + 4 * x2 <= 189)
    model.addConstr(6 * x0 + x1 <= 165)
    model.addConstr(6 * x0 + x1 + 4 * x2 <= 212)
    model.addConstr(11 * x0 + 14 * x2 <= 100)
    model.addConstr(11 * x0 + 8 * x1 <= 62)
    model.addConstr(8 * x1 + 14 * x2 <= 79)
    model.addConstr(11 * x0 + 8 * x1 + 14 * x2 <= 79)
    model.addConstr(x1 + 6 * x2 <= 117)
    model.addConstr(3 * x0 + 6 * x2 <= 45)
    model.addConstr(3 * x0 + x1 + 6 * x2 <= 45)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Hours worked by George: ", x0.varValue)
        print("Hours worked by Peggy: ", x1.varValue)
        print("Hours worked by Mary: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
