
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    ravioli = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ravioli")
    peanutbutter_sandwiches = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="peanutbutter_sandwiches")
    chicken_breasts = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken_breasts")


    # Set objective function
    m.setObjective(5*ravioli + 6*peanutbutter_sandwiches + 6*chicken_breasts, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(15*ravioli + 15*peanutbutter_sandwiches >= 13, "c1")
    m.addConstr(15*ravioli + 8*chicken_breasts >= 33, "c2")
    m.addConstr(15*ravioli + 15*peanutbutter_sandwiches + 8*chicken_breasts >= 33, "c3")
    m.addConstr(17*peanutbutter_sandwiches + 15*chicken_breasts >= 30, "c4")
    m.addConstr(13*ravioli + 17*peanutbutter_sandwiches + 15*chicken_breasts >= 68, "c5")
    m.addConstr(2*ravioli - 5*chicken_breasts >= 0, "c6")
    m.addConstr(-1*peanutbutter_sandwiches + 1*chicken_breasts >= 0, "c7")
    m.addConstr(15*ravioli + 8*chicken_breasts <= 38, "c8")
    m.addConstr(15*ravioli + 15*peanutbutter_sandwiches <= 68, "c9")
    m.addConstr(15*ravioli <= 112, "c10")
    m.addConstr(13*ravioli + 17*peanutbutter_sandwiches + 15*chicken_breasts <= 237, "c11")



    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Objective Value:', m.objVal)
        for v in m.getVars():
            print(f'{v.varName}: {v.x}')
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GrorbiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
