
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    x0 = model.addVar(name="ravioli", lb=0)  # ravioli can be fractional
    x1 = model.addVar(name="peanutbutter_sandwiches", lb=0, integrality=gurobi.GRB.INTEGER)  # peanutbutter sandwiches must be integer
    x2 = model.addVar(name="chicken_breasts", lb=0)  # chicken breasts can be fractional

    # Objective function
    model.setObjective(5*x0 + 6*x1 + 6*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(15*x0 + 15*x1 >= 13)
    model.addConstr(15*x0 + 8*x2 >= 33)
    model.addConstr(15*x0 + 15*x1 + 8*x2 >= 33)
    model.addConstr(17*x1 + 15*x2 >= 30)
    model.addConstr(13*x0 + 17*x1 + 15*x2 >= 68)
    model.addConstr(2*x0 - 5*x2 >= 0)
    model.addConstr(-x1 + x2 >= 0)
    model.addConstr(15*x0 + 8*x2 <= 38)
    model.addConstr(15*x0 + 15*x1 <= 68)

    # Resource constraints (already considered in problem description)
    # r0: 15*x0 + 15*x1 + 8*x2 <= 112
    model.addConstr(15*x0 + 15*x1 + 8*x2 <= 112, name='iron_constraint')
    # r1: 13*x0 + 17*x1 + 15*x2 <= 237
    model.addConstr(13*x0 + 17*x1 + 15*x2 <= 237, name='cost_constraint')

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Ravioli: {x0.varValue}")
        print(f"Peanutbutter sandwiches: {x1.varValue}")
        print(f"Chicken breasts: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
