
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("food_optimization")

    # Create variables
    potatoes = m.addVar(lb=0, name="potatoes")
    sashimi = m.addVar(lb=0, name="sashimi")
    ramen = m.addVar(lb=0, name="ramen")


    # Set objective function
    m.setObjective(6*potatoes + 5*sashimi + 2*ramen, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(12.31*sashimi + 5.36*ramen >= 34, "c1")
    m.addConstr(1.7*potatoes + 5.36*ramen >= 61, "c2")
    m.addConstr(1.7*potatoes + 12.31*sashimi + 5.36*ramen >= 67, "c3")
    m.addConstr(10.23*potatoes + 4.49*sashimi >= 100, "c4")
    m.addConstr(1.7*potatoes + 5.36*ramen <= 204, "c5")
    m.addConstr(1.7*potatoes + 12.31*sashimi + 5.36*ramen <= 204, "c6")
    m.addConstr(10.23*potatoes + 6.03*ramen <= 163, "c7")
    m.addConstr(10.23*potatoes + 4.49*sashimi + 6.03*ramen <= 163, "c8")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
