
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="potatoes", lb=0)  # No lower bound specified, assuming 0
    x1 = model.addVar(name="sashimi", lb=0)  # No lower bound specified, assuming 0
    x2 = model.addVar(name="bowls_of_instant_ramen", lb=0)  # No lower bound specified, assuming 0

    # Define the objective function
    model.setObjective(6 * x0 + 5 * x1 + 2 * x2, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(12.31 * x1 + 5.36 * x2 >= 34)
    model.addConstr(1.7 * x0 + 5.36 * x2 >= 61)
    model.addConstr(1.7 * x0 + 12.31 * x1 + 5.36 * x2 >= 67)
    model.addConstr(10.23 * x0 + 4.49 * x1 >= 100)
    model.addConstr(1.7 * x0 + 5.36 * x2 <= 204)
    model.addConstr(1.7 * x0 + 12.31 * x1 + 5.36 * x2 <= 204)
    model.addConstr(10.23 * x0 + 6.03 * x2 <= 163)
    model.addConstr(10.23 * x0 + 4.49 * x1 + 6.03 * x2 <= 163)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Potatoes: {x0.varValue}")
        print(f"Sashimi: {x1.varValue}")
        print(f"Bowls of instant ramen: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
