
import gurobi as gp

# Define variables
x = gp.mvar([7], lb=[0], ub=[gp.GRB.INFINITY], vtype=gp.GRB.INTEGER)

# Objective function coefficients
obj_func_coeffs = [6.08, 4.2, 2.24, 2.23, 1.51, 3.57, 7.95,
                   8.13, 3.68, 3.03, 2.22, 6.41, 4.29,
                   5.2, 5.66, 3.38, 1.02, 6.03,
                   6.37, 9.7, 9.0, 7.72,
                   7.66, 6.78, 9.05,
                   9.27, 3.66,
                   9.74,
                   1.22, 9.4, 2.63, 8.18, 3.38, 3.69, 9.86]

# Define the model
m = gp.Model()

# Add variables to the model with names
m.addVars(['pansies', 'zucchini vines', 'agave', 'coleus', 'carrots', 'chives', 'verbenas'],
           vtype=gp.GRB.INTEGER, lb=0)

# Set objective function
m.setObjective(6.08 * m['pansies'] ** 2 + 4.2 * m['pansies'] * m['zucchini vines'] +
               2.24 * m['pansies'] * m['agave'] + 2.23 * m['pansies'] * m['coleus'] +
               1.51 * m['pansies'] * m['carrots'] + 3.57 * m['pansies'] * m['chives'] +
               7.95 * m['pansies'] * m['verbenas'] + 8.13 * m['zucchini vines'] ** 2 +
               3.68 * m['zucchini vines'] * m['agave'] + 3.03 * m['zucchini vines'] * m['coleus'] +
               2.22 * m['zucchini vines'] * m['carrots'] + 6.41 * m['zucchini vines'] * m['chives'] +
               4.29 * m['zucchini vines'] * m['verbenas'] + 5.2 * m['agave'] ** 2 +
               5.66 * m['agave'] * m['coleus'] + 3.38 * m['agave'] * m['carrots'] +
               1.02 * m['agave'] * m['chives'] + 6.03 * m['agave'] * m['verbenas'] +
               6.37 * m['coleus'] ** 2 + 9.7 * m['coleus'] * m['carrots'] +
               9.0 * m['coleus'] * m['chives'] + 7.72 * m['coleus'] * m['verbenas'] +
               7.66 * m['carrots'] ** 2 + 6.78 * m['carrots'] * m['chives'] +
               9.05 * m['carrots'] * m['verbenas'] + 9.27 * m['chives'] ** 2 +
               3.66 * m['chives'] * m['verbenas'] + 9.74 * m['verbenas'] ** 2 +
               1.22 * m['pansies'] + 9.4 * m['zucchini vines'] + 2.63 * m['agave'] +
               8.18 * m['coleus'] + 3.38 * m['carrots'] + 3.69 * m['chives'] +
               9.86 * m['verbenas'], gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(m['pansies'] >= 10)
m.addConstr(m['zucchini vines'] >= 10)
m.addConstr(m['agave'] >= 3)
m.addConstr(m['coleus'] >= 1)
m.addConstr(m['carrots'] >= 1)
m.addConstr(m['chives'] >= 9)
m.addConstr(m['verbenas'] >= 11)

# ... Add other constraints similarly

m.addConstr(6 * m['pansies'] + 12 * m['zucchini vines'] + 7 * m['agave'] + 3 * m['coleus'] +
             5 * m['carrots'] + 14 * m['chives'] + 2 * m['verbenas'] <= 168)

m.addConstr(10 * m['pansies'] + 10 * m['zucchini vines'] + 3 * m['agave'] + m['coleus'] +
             m['carrots'] + 9 * m['chives'] + 11 * m['verbenas'] <= 246)

m.addConstr(5 * m['pansies'] + 4 * m['zucchini vines'] + 9 * m['agave'] + 5 * m['coleus'] +
             11 * m['carrots'] + 6 * m['chives'] + 10 * m['verbenas'] <= 232)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print('Objective: %g' % m.objVal)
    for v in m.vars:
        print('%s: %g' % (v.varName, v.x))
else:
    print('No optimal solution found')
