
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamin_b6 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b6")
vitamin_b12 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b12")
vitamin_k = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_k")
vitamin_a = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_a")
vitamin_b7 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b7")
vitamin_b3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b3")


# Set objective function
m.setObjective(4.24 * vitamin_b6 + 5.15 * vitamin_b12 + 8.7 * vitamin_k + 8.62 * vitamin_a + 9.04 * vitamin_b7 + 7.04 * vitamin_b3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(10*vitamin_b6 + 7*vitamin_b12 + 6*vitamin_k + 7*vitamin_a + 2*vitamin_b7 + 3*vitamin_b3 <= 142, "r0")
m.addConstr(7 * vitamin_b12 + 2 * vitamin_b7 >= 9)
m.addConstr(10 * vitamin_b6 + 7 * vitamin_b12 >= 14)
m.addConstr(7 * vitamin_a + 2 * vitamin_b7 >= 9)
m.addConstr(7 * vitamin_a + 3 * vitamin_b3 >= 18)
m.addConstr(7 * vitamin_b12 + 3 * vitamin_b3 >= 9)
m.addConstr(10 * vitamin_b6 + 6 * vitamin_k >= 9)
m.addConstr(10 * vitamin_b6 + 7 * vitamin_a >= 17)
m.addConstr(10 * vitamin_b6 + 7 * vitamin_b12 + 3 * vitamin_b3 >= 19)
m.addConstr(10 * vitamin_b6 + 6 * vitamin_k + 7 * vitamin_a >= 19)
m.addConstr(7 * vitamin_b12 + 7 * vitamin_a + 2 * vitamin_b7 >= 19)
m.addConstr(7 * vitamin_b12 + 6 * vitamin_k + 7 * vitamin_a >= 19)
m.addConstr(10 * vitamin_b6 + 7 * vitamin_a + 3 * vitamin_b3 >= 19)
m.addConstr(6 * vitamin_k + 2 * vitamin_b7 + 3 * vitamin_b3 >= 19)
m.addConstr(10 * vitamin_b6 + 2 * vitamin_b7 + 3 * vitamin_b3 >= 19)

# ... (rest of the constraints from the JSON, following the same pattern)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)

