
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("computer_competence")

    # Create variables
    john = m.addVar(vtype=gp.GRB.CONTINUOUS, name="john")
    hank = m.addVar(vtype=gp.GRB.INTEGER, name="hank")
    bobby = m.addVar(vtype=gp.GRB.CONTINUOUS, name="bobby")
    dale = m.addVar(vtype=gp.GRB.CONTINUOUS, name="dale")


    # Set objective
    m.setObjective(1*john + 7*hank + 1*bobby + 1*dale, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(8*john + 10*dale >= 37, "c0")
    m.addConstr(6*hank + 11*bobby >= 35, "c1")
    m.addConstr(8*john + 10*dale <= 158, "c2")
    m.addConstr(8*john + 6*hank <= 109, "c3")
    m.addConstr(6*hank + 11*bobby <= 193, "c4")
    m.addConstr(6*hank + 10*dale <= 103, "c5")
    m.addConstr(8*john + 6*hank + 11*bobby <= 124, "c6")
    m.addConstr(8*john + 6*hank + 11*bobby + 10*dale <= 124, "c7")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization was infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
