
import gurobi

# Create a new model
model = gurobi.Model()

# Define variables
x1 = model.addVar(name='hours_worked_by_John', lb=0, ub=None)  # fractional
x2 = model.addVar(name='hours_worked_by_Hank', lb=0, ub=None, vtype=gurobi.GRB.INTEGER)  # integer
x3 = model.addVar(name='hours_worked_by_Bobby', lb=0, ub=None)  # fractional
x4 = model.addVar(name='hours_worked_by_Dale', lb=0, ub=None)  # fractional

# Set objective function
model.setObjective(1*x1 + 7*x2 + 1*x3 + 1*x4, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(8*x1 + 10*x4 >= 37)
model.addConstr(6*x2 + 11*x3 >= 35)
model.addConstr(8*x1 + 10*x4 <= 158)
model.addConstr(8*x1 + 6*x2 <= 109)
model.addConstr(6*x2 + 11*x3 <= 193)
model.addConstr(6*x2 + 10*x4 <= 103)
model.addConstr(8*x1 + 6*x2 + 11*x3 <= 124)
model.addConstr(8*x1 + 6*x2 + 11*x3 + 10*x4 <= 124)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', model.objval)
    print('Hours worked by John: ', x1.varValue)
    print('Hours worked by Hank: ', x2.varValue)
    print('Hours worked by Bobby: ', x3.varValue)
    print('Hours worked by Dale: ', x4.varValue)
else:
    print('The model is infeasible')
