
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
george = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="george")
bobby = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bobby")
john = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="john")
bill = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bill")
paul = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="paul")
dale = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="dale")


# Set objective function
m.setObjective(9.32*george + 4.93*bobby + 3.28*john + 2.67*bill + 9.07*paul + 6.77*dale, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(1.17*george + 2.35*paul >= 32)
m.addConstr(5.86*bobby + 4.18*john >= 36)
m.addConstr(5.86*bobby + 14.56*dale >= 36)
m.addConstr(5.86*bobby + 7.39*bill >= 41)
m.addConstr(2.35*paul + 14.56*dale >= 32)
m.addConstr(1.17*george + 7.39*bill >= 14)
m.addConstr(4.18*john + 7.39*bill >= 35)
m.addConstr(5.86*bobby + 2.35*paul >= 37)
m.addConstr(1.17*george + 4.18*john >= 41)
m.addConstr(7.39*bill + 14.56*dale >= 33)
m.addConstr(7.39*bill + 2.35*paul >= 25)
m.addConstr(1.17*george + 7.39*bill + 2.35*paul >= 32)
m.addConstr(5.86*bobby + 4.18*john + 7.39*bill >= 32)
m.addConstr(4.18*john + 7.39*bill + 2.35*paul >= 32)
m.addConstr(1.17*george + 5.86*bobby + 2.35*paul >= 32)
m.addConstr(1.17*george + 7.39*bill + 2.35*paul >= 41)
m.addConstr(5.86*bobby + 4.18*john + 7.39*bill >= 41)
m.addConstr(4.18*john + 7.39*bill + 2.35*paul >= 41)
m.addConstr(1.17*george + 5.86*bobby + 2.35*paul >= 41)
m.addConstr(1.17*george + 7.39*bill + 2.35*paul >= 25)
m.addConstr(5.86*bobby + 4.18*john + 7.39*bill >= 25)
m.addConstr(4.18*john + 7.39*bill + 2.35*paul >= 25)
m.addConstr(1.17*george + 5.86*bobby + 2.35*paul >= 25)
m.addConstr(1.17*george + 7.39*bill + 2.35*paul >= 35)
m.addConstr(5.86*bobby + 4.18*john + 7.39*bill >= 35)
m.addConstr(4.18*john + 7.39*bill + 2.35*paul >= 35)
m.addConstr(1.17*george + 5.86*bobby + 2.35*paul >= 35)
m.addConstr(1.17*george + 5.86*bobby + 4.18*john + 7.39*bill + 2.35*paul + 14.56*dale >= 35)
m.addConstr(-george + 2*john >= 0)
m.addConstr(7*paul - 3*dale >= 0)
m.addConstr(2.35*paul + 14.56*dale <= 121)
m.addConstr(4.18*john + 2.35*paul <= 166)
m.addConstr(1.17*george + 14.56*dale <= 198)
m.addConstr(1.17*george + 7.39*bill <= 215)
m.addConstr(1.17*george + 2.35*paul <= 148)
m.addConstr(4.18*john + 7.39*bill <= 143)
m.addConstr(1.17*george + 5.86*bobby <= 114)
m.addConstr(5.86*bobby + 14.56*dale <= 260)
m.addConstr(5.86*bobby + 2.35*paul <= 187)
m.addConstr(7.39*bill + 14.56*dale <= 155)
m.addConstr(5.86*bobby + 4.18*john <= 257)
m.addConstr(5.86*bobby + 4.18*john + 14.56*dale <= 181)
m.addConstr(1.17*george + 5.86*bobby + 14.56*dale <= 118)
m.addConstr(1.17*george + 4.18*john + 2.35*paul <= 105)
m.addConstr(4.18*john + 2.35*paul + 14.56*dale <= 202)
m.addConstr(1.17*george + 7.39*bill + 2.35*paul <= 56)
m.addConstr(1.17*george + 5.86*bobby + 7.39*bill <= 44)
m.addConstr(1.17*george + 4.18*john + 7.39*bill <= 129)
m.addConstr(1.17*george + 4.18*john + 14.56*dale <= 263)
m.addConstr(5.86*bobby + 4.18*john + 2.35*paul <= 131)
m.addConstr(5.86*bobby + 7.39*bill + 14.56*dale <= 205)
m.addConstr(1.17*george + 5.86*bobby + 2.35*paul <= 73)
m.addConstr(5.86*bobby + 7.39*bill + 2.35*paul <= 220)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

