
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(vtype=gp.GRB.INTEGER, name="black_beans")
x1 = m.addVar(vtype=gp.GRB.INTEGER, name="strawberries")
x2 = m.addVar(vtype=gp.GRB.INTEGER, name="blueberry_pies")
x3 = m.addVar(vtype=gp.GRB.INTEGER, name="bananas")

# Set objective function
m.setObjective(3*x0 + 3*x1 + 4*x2 + x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x0 + 12*x1 + 8*x2 + 4*x3 <= 610, "dollar_cost")
m.addConstr(20*x0 + x1 + 22*x2 + 6*x3 <= 645, "carbohydrates")
m.addConstr(23*x0 + 6*x1 + 19*x2 + 18*x3 <= 299, "sourness")
m.addConstr(8*x2 + 4*x3 >= 53, "c1")
m.addConstr(12*x1 + 8*x2 >= 143, "c2")
m.addConstr(2*x0 + 12*x1 >= 73, "c3")
m.addConstr(2*x0 + 8*x2 >= 109, "c4")
m.addConstr(2*x0 + 12*x1 + 4*x3 >= 129, "c5")
m.addConstr(x1 + 22*x2 + 6*x3 >= 146, "c6")
m.addConstr(20*x0 + x1 + 6*x3 >= 146, "c7")
m.addConstr(20*x0 + 22*x2 + 6*x3 >= 146, "c8")
m.addConstr(20*x0 + x1 + 22*x2 >= 146, "c9")
m.addConstr(x1 + 22*x2 + 6*x3 >= 84, "c10")
m.addConstr(20*x0 + x1 + 6*x3 >= 84, "c11")
m.addConstr(20*x0 + 22*x2 + 6*x3 >= 84, "c12")
m.addConstr(20*x0 + x1 + 22*x2 >= 84, "c13")
m.addConstr(x1 + 22*x2 + 6*x3 >= 113, "c14")
m.addConstr(20*x0 + x1 + 6*x3 >= 113, "c15")
m.addConstr(20*x0 + 22*x2 + 6*x3 >= 113, "c16")
m.addConstr(20*x0 + x1 + 22*x2 >= 113, "c17")
m.addConstr(x1 + 22*x2 + 6*x3 >= 89, "c18")
m.addConstr(20*x0 + x1 + 6*x3 >= 89, "c19")
m.addConstr(20*x0 + 22*x2 + 6*x3 >= 89, "c20")
m.addConstr(20*x0 + x1 + 22*x2 >= 89, "c21")
m.addConstr(23*x0 + 6*x1 + 18*x3 >= 38, "c22")
m.addConstr(-5*x1 + x2 + x3 >= 0, "c23")
m.addConstr(2*x0 + 4*x3 <= 440, "c24")
m.addConstr(2*x0 + 8*x2 <= 172, "c25")
m.addConstr(2*x0 + 12*x1 <= 291, "c26")
m.addConstr(12*x1 + 8*x2 <= 193, "c27")
m.addConstr(2*x0 + 12*x1 + 8*x2 + 4*x3 <= 193, "c28")
m.addConstr(x1 + 22*x2 <= 574, "c29")
m.addConstr(20*x0 + 22*x2 <= 204, "c30")
m.addConstr(22*x2 + 6*x3 <= 336, "c31")
m.addConstr(20*x0 + x1 <= 217, "c32")
m.addConstr(20*x0 + 6*x3 <= 535, "c33")
m.addConstr(20*x0 + 22*x2 + 6*x3 <= 168, "c34")
m.addConstr(20*x0 + x1 + 6*x3 <= 523, "c35")
m.addConstr(20*x0 + x1 + 22*x2 <= 611, "c36")
m.addConstr(20*x0 + x1 + 22*x2 + 6*x3 <= 611, "c37")
m.addConstr(23*x0 + 6*x1 <= 109, "c38")
m.addConstr(19*x2 + 18*x3 <= 80, "c39")
m.addConstr(23*x0 + 6*x1 + 19*x2 + 18*x3 <= 80, "c40")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("The problem could not be solved to optimality.")

