
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_B12")
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_B5")
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="iron")


    # Set objective function
    m.setObjective(5*x0 + 9*x1 + 2*x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(6*x0 + 20*x1 + 11*x2 <= 170, "c0")
    m.addConstr(12*x0 + 9*x1 + 8*x2 <= 76, "c1")
    m.addConstr(7*x0 + 13*x1 + 8*x2 <= 132, "c2")
    m.addConstr(9*x1 + 8*x2 >= 8, "c3")
    m.addConstr(12*x0 + 9*x1 + 8*x2 >= 23, "c4")
    m.addConstr(6*x0 + 11*x2 <= 98, "c5")
    m.addConstr(6*x0 + 20*x1 + 11*x2 <= 98, "c6")
    m.addConstr(9*x1 + 8*x2 <= 66, "c7")
    m.addConstr(12*x0 + 9*x1 + 8*x2 <= 66, "c8")
    m.addConstr(13*x1 + 8*x2 <= 106, "c9")
    m.addConstr(7*x0 + 13*x1 <= 67, "c10")
    m.addConstr(7*x0 + 13*x1 + 8*x2 <= 67, "c11")

    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('Vitamin B12: %g' % x0.x)
        print('Vitamin B5: %g' % x1.x)
        print('Iron: %g' % x2.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
