
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", lb=-gurobi.GRB.INFINITY)  # milligrams of vitamin B12
    x1 = model.addVar(name="x1", lb=-gurobi.GRB.INFINITY)  # milligrams of vitamin B5
    x2 = model.addVar(name="x2", lb=-gurobi.GRB.INFINITY)  # milligrams of iron

    # Objective function
    model.setObjective(5 * x0 + 9 * x1 + 2 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(6 * x0 + 20 * x1 + 11 * x2 <= 170)  # muscle growth index
    model.addConstr(12 * x0 + 9 * x1 + 8 * x2 >= 23)  # energy stability index total
    model.addConstr(6 * x0 + 11 * x2 <= 98)  # muscle growth index for x0 and x2
    model.addConstr(9 * x1 + 8 * x2 >= 8)  # energy stability index for x1 and x2
    model.addConstr(9 * x1 + 8 * x2 <= 66)  # energy stability index for x1 and x2
    model.addConstr(12 * x0 + 9 * x1 + 8 * x2 <= 66)  # energy stability index total
    model.addConstr(13 * x1 + 8 * x2 <= 106)  # cognitive performance index for x1 and x2
    model.addConstr(7 * x0 + 13 * x1 <= 67)  # cognitive performance index for x0 and x1
    model.addConstr(7 * x0 + 13 * x1 + 8 * x2 <= 67)  # cognitive performance index total

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B12: {x0.varValue}")
        print(f"Milligrams of vitamin B5: {x1.varValue}")
        print(f"Milligrams of iron: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
