
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = {}
variables = ['protein bars', 'pickles', 'green beans', 'bananas', 'potatoes', 'kiwis']
for i, var_name in enumerate(variables):
    if var_name in ['protein bars', 'green beans', 'kiwis']:
        x[i] = m.addVar(vtype=GRB.INTEGER, name=var_name)
    else:
        x[i] = m.addVar(vtype=GRB.CONTINUOUS, name=var_name)


# Set objective function
obj = 2*x[0]**2 + 9*x[0]*x[1] + x[0]*x[2] + x[0]*x[3] + 4*x[0]*x[4] + 8*x[0]*x[5] + 6*x[1]**2 + 3*x[1]*x[2] + 4*x[1]*x[3] + 2*x[1]*x[4] + 3*x[1]*x[5] + 7*x[2]**2 + 2*x[2]*x[3] + 9*x[2]*x[4] + 7*x[2]*x[5] + 7*x[3]**2 + x[3]*x[4] + 2*x[3]*x[5] + 2*x[4]**2 + 4*x[4]*x[5] + 9*x[5]**2 + 6*x[0] + 5*x[1] + 8*x[2] + 6*x[3] + 4*x[4] + 9*x[5]
m.setObjective(obj, GRB.MINIMIZE)

# Add constraints
resource_constraints = {'r0': {'upper_bound': 822, 'x0': 4, 'x1': 17, 'x2': 3, 'x3': 27, 'x4': 1, 'x5': 20}, 'r1': {'upper_bound': 439, 'x0': 14, 'x1': 10, 'x2': 32, 'x3': 9, 'x4': 8, 'x5': 22}}

m.addConstr(4*x[0] + x[4] >= 79)
m.addConstr(4*x[0] + 27*x[3] >= 102)
m.addConstr(27*x[3] + 20*x[5] >= 133)
m.addConstr(4*x[0] + 27*x[3] <= 146)
m.addConstr(14*x[0] + 9*x[3] >= 40)
m.addConstr(32*x[2] + 8*x[4] >= 28)
m.addConstr(10*x[1] + 32*x[2] >= 64)
m.addConstr(14*x[0] + 8*x[4] >= 52)
m.addConstr(-10*x[0]**2 + x[4]**2 >= 0)
m.addConstr(4*x[0] + 17*x[1] + 3*x[2] <= 240)
m.addConstr(4*x[0] + x[4] + 20*x[5] <= 594)

m.addConstr(sum([resource_constraints['r0'][f'x{i}'] * x[i] for i in range(6)]) <= resource_constraints['r0']['upper_bound'], "fiber_constraint")
m.addConstr(sum([resource_constraints['r1'][f'x{i}'] * x[i] for i in range(6)]) <= resource_constraints['r1']['upper_bound'], "cost_constraint")
m.addConstr(sum(x[i] for i in range(6)) >= 101)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

