
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="protein_bars")
x1 = m.addVar(lb=-gp.GRB.INFINITY, name="pickles")
x2 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="green_beans")
x3 = m.addVar(lb=-gp.GRB.INFINITY, name="bananas")
x4 = m.addVar(lb=-gp.GRB.INFINITY, name="potatoes")
x5 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="kiwis")

# Objective function
m.setObjective(2*x0**2 + 9*x0*x1 + x0*x2 + x0*x3 + 4*x0*x4 + 8*x0*x5 + 
               6*x1**2 + 3*x1*x2 + 4*x1*x3 + 2*x1*x4 + 3*x1*x5 + 
               7*x2**2 + 2*x2*x3 + 9*x2*x4 + 7*x2*x5 + 
               7*x3**2 + x3*x4 + 2*x3*x5 + 
               2*x4**2 + 4*x4*x5 + 
               9*x5**2 + 
               6*x0 + 5*x1 + 8*x2 + 6*x3 + 4*x4 + 9*x5, 
               gp.GRB.MINIMIZE)

# Constraints
# Fiber constraints
m.addConstr(4*x0 + 17*x1 + 3*x2 + 27*x3 + x4 + 20*x5 >= 79, name="fiber_1")
m.addConstr(4*x0 + 27*x3 + x4 >= 79, name="fiber_2")
# ... add all other constraints similarly

# Cost constraints
m.addConstr(14*x0 + 10*x1 + 32*x2 + 9*x3 + 8*x4 + 22*x5 <= 439, name="cost")

# Variable bounds
m.addConstr(x0 >= 0, name="x0_bound")
m.addConstr(x2 >= 0, name="x2_bound")
m.addConstr(x5 >= 0, name="x5_bound")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("protein_bars: ", x0.varValue)
    print("pickles: ", x1.varValue)
    print("green_beans: ", x2.varValue)
    print("bananas: ", x3.varValue)
    print("potatoes: ", x4.varValue)
    print("kiwis: ", x5.varValue)
else:
    print("No optimal solution found")
