
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(name="x0")  # milligrams of vitamin B2
    x1 = m.addVar(name="x1")  # milligrams of magnesium


    # Set objective function
    m.setObjective(9*x0**2 + 4*x0*x1 + 7*x1**2 + 8*x0, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(3*x0 + 2*x1 >= 55, "c0")
    m.addConstr(3*x0 + 2*x1 <= 142, "c1")
    m.addConstr(8*x0**2 + x1**2 >= 21, "c2")
    m.addConstr(8*x0 + x1 >= 21, "c3")
    m.addConstr(8*x0**2 + x1**2 <= 64, "c4")
    m.addConstr(-3*x0 + 3*x1 >= 0, "c5")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('x0: %g' % x0.x)
        print('x1: %g' % x1.x)
    elif m.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

