
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x1")
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x2")
    
    # Objective function
    model.setObjective(9*x1**2 + 4*x1*x2 + 7*x2**2 + 8*x1, gurobi.GRB.MINIMIZE)
    
    # Constraints
    model.addConstr(3*x1 == 3, name="immune_support_index_B2")
    model.addConstr(8*x1 == 8, name="digestive_support_index_B2")
    model.addConstr(3*x1 + 2*x2 >= 55, name="min_immune_support")
    model.addConstr(8*x1 + x2 >= 21, name="min_digestive_support")
    model.addConstr(8*x1**2 + x2**2 >= 21, name="min_digestive_support_squared")
    model.addConstr(-3*x1 + 3*x2 >= 0, name="balance_constraint")
    model.addConstr(3*x1 + 2*x2 <= 142, name="max_immune_support")
    model.addConstr(8*x1**2 + x2**2 <= 64, name="max_digestive_support_squared")
    
    # Solve the model
    model.optimize()
    
    # Print the status
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print("x1:", x1.varValue)
        print("x2:", x2.varValue)
        print("Objective:", model.objVal)
    elif model.status == gurobi.GRB.Status.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_optimization_problem()
