
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hours_worked_by_Bill")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hours_worked_by_John")

# Set the objective function
m.setObjective(4.03*x1 + 7.68*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(6.44*x1 + 5.84*x2 >= 5, "organization_score_lower")
m.addConstr(2.16*x1 + 2.06*x2 >= 39, "productivity_rating_lower")
m.addConstr(4.71*x1 + 2.29*x2 >= 7, "computer_competence_rating_lower")
m.addConstr(4*x1 - 7*x2 >= 0, "additional_linear_constraint")
m.addConstr(6.44*x1 + 5.84*x2 <= 13, "organization_score_upper")
m.addConstr(2.16*x1 + 2.06*x2 <= 78, "productivity_rating_upper")
m.addConstr(4.71*x1 + 2.29*x2 <= 15, "computer_competence_rating_upper")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Bill: {x1.x}")
    print(f"Hours worked by John: {x2.x}")
else:
    print("No optimal solution found.")
