
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="hours_worked_by_Bill", lb=0)
    x2 = model.addVar(name="hours_worked_by_John", lb=0)

    # Objective function
    model.setObjective(4.03*x1 + 7.68*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(6.44*x1 + 5.84*x2 >= 5, name="organization_score_constraint")
    model.addConstr(2.16*x1 + 2.06*x2 >= 39, name="productivity_rating_constraint")
    model.addConstr(4.71*x1 + 2.29*x2 >= 7, name="computer_competence_rating_constraint")
    model.addConstr(4*x1 - 7*x2 >= 0, name="hours_worked_constraint")
    model.addConstr(6.44*x1 + 5.84*x2 <= 13, name="organization_score_upper_bound")
    model.addConstr(2.16*x1 + 2.06*x2 <= 78, name="productivity_rating_upper_bound")
    model.addConstr(4.71*x1 + 2.29*x2 <= 15, name="computer_competence_rating_upper_bound")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Bill: {x1.x}")
        print(f"Hours worked by John: {x2.x}")
        print(f"Objective function value: {model.objval}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
