
import gurobipy as gp

# Create a new model
m = gp.Model("plant_optimization")

# Create variables
chili_plants = m.addVar(vtype=gp.GRB.INTEGER, name="chili_plants")
pansies = m.addVar(vtype=gp.GRB.INTEGER, name="pansies")
roses = m.addVar(vtype=gp.GRB.INTEGER, name="roses")

# Set objective function
m.setObjective(8 * chili_plants + 7 * pansies + 3 * roses, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(5 * chili_plants + 2 * roses <= 13, "growth_speed_chili_roses")
m.addConstr(4 * pansies + 2 * roses <= 11, "growth_speed_pansies_roses")
m.addConstr(5 * chili_plants + 4 * pansies + 2 * roses <= 26, "growth_speed_total")
m.addConstr(5 * chili_plants + 1 * pansies <= 21, "cost_chili_pansies")
m.addConstr(5 * chili_plants + 2 * roses <= 11, "cost_chili_roses")
m.addConstr(1 * pansies + 2 * roses <= 23, "cost_pansies_roses")
m.addConstr(5 * chili_plants + 1 * pansies + 2 * roses <= 28, "cost_total")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('chili_plants:', chili_plants.x)
    print('pansies:', pansies.x)
    print('roses:', roses.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

