
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="chili_plants", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="pansies", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="roses", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(8*x0 + 7*x1 + 3*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(5*x0 + 2*x2 <= 13)
    model.addConstr(4*x1 + 2*x2 <= 11)
    model.addConstr(5*x0 + 4*x1 + 2*x2 <= 26)
    model.addConstr(5*x0 + x1 <= 21)
    model.addConstr(5*x0 + 2*x2 <= 11)
    model.addConstr(x1 + 2*x2 <= 23)
    model.addConstr(5*x0 + x1 + 2*x2 <= 28)

    # Non-negativity constraints (implicit in Gurobi for integer variables)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Chili plants: {x0.varValue}")
        print(f"Pansies: {x1.varValue}")
        print(f"Roses: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
