
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
x = m.addVars(5, lb=0, vtype=[gp.GRB.CONTINUOUS, gp.GRB.CONTINUOUS, gp.GRB.CONTINUOUS, gp.GRB.CONTINUOUS, gp.GRB.INTEGER], name=["B6", "Iron", "Calcium", "B9", "Magnesium"])


# Set objective function
m.setObjective(3.18 * x[0] + 6.26 * x[1] + 6.06 * x[2] + 2.41 * x[3] + 10.0 * x[4], gp.GRB.MAXIMIZE)

# Add constraints
cardio_support = {0: 10, 1: 12, 2: 14, 3: 9, 4: 5}
digestive_support = {0: 14, 1: 4, 2: 6, 3: 10, 4: 13}

m.addConstr(sum([cardio_support[i] * x[i] for i in range(5)]) <= 155, "r0_ub")
m.addConstr(sum([digestive_support[i] * x[i] for i in range(5)]) <= 102, "r1_ub")


m.addConstr(cardio_support[0] * x[0] + cardio_support[4] * x[4] >= 10)
m.addConstr(cardio_support[1] * x[1] + cardio_support[2] * x[2] >= 12)
m.addConstr(cardio_support[2] * x[2] + cardio_support[3] * x[3] >= 31)
m.addConstr(cardio_support[0] * x[0] + cardio_support[1] * x[1] >= 21)
m.addConstr(cardio_support[2] * x[2] + cardio_support[4] * x[4] >= 20)
m.addConstr(cardio_support[1] * x[1] + cardio_support[3] * x[3] >= 24)
m.addConstr(cardio_support[1] * x[1] + cardio_support[4] * x[4] >= 26)
m.addConstr(cardio_support[0] * x[0] + cardio_support[1] * x[1] + cardio_support[4] * x[4] >= 15)
m.addConstr(cardio_support[0] * x[0] + cardio_support[1] * x[1] + cardio_support[3] * x[3] >= 15)
m.addConstr(cardio_support[0] * x[0] + cardio_support[1] * x[1] + cardio_support[4] * x[4] >= 24)
m.addConstr(cardio_support[0] * x[0] + cardio_support[1] * x[1] + cardio_support[3] * x[3] >= 24)

m.addConstr(digestive_support[3] * x[3] + digestive_support[4] * x[4] >= 17)
m.addConstr(digestive_support[2] * x[2] + digestive_support[3] * x[3] >= 20)
m.addConstr(digestive_support[1] * x[1] + digestive_support[4] * x[4] >= 17)
m.addConstr(digestive_support[0] * x[0] + digestive_support[2] * x[2] >= 16)

digestive_constraints_rhs = [19] * 8 + [74, 51, 38, 95, 57, 50, 47, 47, 37, 31, 35, 72, 86, 86]
digestive_constraints_vars = [[0,2,3], [1,3,4], [0,2,4], [1,2,4], [0,3,4], [0,1,3], [1,2,3], [2,3,4], [0,1], [2,4], [2,3], [0,1,2], [2,3,4], [0,1,4], [0,1,2,3,4]]
cardio_constraints_rhs = [74, 51, 38, 95, 57, 50, 47, 47]
cardio_constraints_vars = [[0,1], [2,4], [2,3], [0,2], [1,4], [0,4], [0,1,3], [0,1,2,3,4]]

for rhs, vars in zip(digestive_constraints_rhs, digestive_constraints_vars):
    m.addConstr(sum([digestive_support[i] * x[i] for i in vars]) <= rhs)
    
for rhs, vars in zip(cardio_constraints_rhs, cardio_constraints_vars):
    m.addConstr(sum([cardio_support[i] * x[i] for i in vars]) <= rhs)


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
    print('Obj: %g' % m.objVal)
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

