
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="x0", lb=0)  # milligrams of vitamin B6
x1 = model.addVar(name="x1", lb=0)  # milligrams of iron
x2 = model.addVar(name="x2", lb=0)  # milligrams of calcium
x3 = model.addVar(name="x3", lb=0)  # milligrams of vitamin B9
x4 = model.addVar(name="x4", lb=0, type=gurobi.GRB.INTEGER)  # milligrams of magnesium

# Objective function
model.setObjective(3.18*x0 + 6.26*x1 + 6.06*x2 + 2.41*x3 + 10.0*x4, gurobi.GRB.MAXIMIZE)

# Constraints
# Cardiovascular Support Index Constraints
model.addConstr(10*x0 <= 155)
model.addConstr(14*x0 <= 102)
model.addConstr(12*x1 <= 155)
model.addConstr(4*x1 <= 102)
model.addConstr(14*x2 <= 155)
model.addConstr(6*x2 <= 102)
model.addConstr(9*x3 <= 155)
model.addConstr(10*x3 <= 102)
model.addConstr(5*x4 <= 155)
model.addConstr(13*x4 <= 102)
model.addConstr(10*x0 + 5*x4 >= 10)
model.addConstr(12*x1 + 14*x2 >= 12)
model.addConstr(14*x2 + 9*x3 >= 31)
model.addConstr(10*x0 + 12*x1 >= 21)
model.addConstr(14*x2 + 5*x4 >= 20)
model.addConstr(12*x1 + 9*x3 >= 24)
model.addConstr(4*x1 + 13*x4 >= 26)
model.addConstr(10*x0 + 12*x1 + 5*x4 >= 15)
model.addConstr(10*x0 + 12*x1 + 9*x3 >= 15)
model.addConstr(10*x0 + 12*x1 + 5*x4 >= 24)
model.addConstr(10*x0 + 12*x1 + 9*x3 >= 24)

# Digestive Support Index Constraints
model.addConstr(14*x0 + 6*x2 + 10*x3 >= 17)
model.addConstr(6*x2 + 10*x3 + 13*x4 >= 17)
model.addConstr(4*x1 + 13*x4 >= 17)
model.addConstr(14*x0 + 6*x2 >= 16)
model.addConstr(14*x0 + 6*x2 + 10*x3 >= 13)
model.addConstr(4*x1 + 10*x3 + 13*x4 >= 13)
model.addConstr(14*x0 + 6*x2 + 13*x4 >= 13)
model.addConstr(4*x1 + 6*x2 + 13*x4 >= 13)
model.addConstr(14*x0 + 10*x3 + 13*x4 >= 13)
model.addConstr(14*x0 + 4*x1 + 10*x3 >= 13)
model.addConstr(4*x1 + 6*x2 + 10*x3 >= 13)
model.addConstr(6*x2 + 10*x3 + 13*x4 >= 13)

# Upper Bound Constraints
model.addConstr(10*x0 + 12*x1 <= 74)
model.addConstr(14*x2 + 5*x4 <= 51)
model.addConstr(14*x2 + 9*x3 <= 38)
model.addConstr(10*x0 + 14*x2 <= 95)
model.addConstr(12*x1 + 5*x4 <= 57)
model.addConstr(10*x0 + 5*x4 <= 50)
model.addConstr(10*x0 + 12*x1 + 9*x3 <= 47)
model.addConstr(10*x0 + 12*x1 + 14*x2 + 9*x3 + 5*x4 <= 47)

# Other Constraints
model.addConstr(6*x2 + 13*x4 <= 37)
model.addConstr(10*x3 + 13*x4 <= 74)
model.addConstr(6*x2 + 10*x3 <= 31)
model.addConstr(14*x0 + 4*x1 + 6*x2 <= 35)
model.addConstr(6*x2 + 10*x3 + 13*x4 <= 72)
model.addConstr(14*x0 + 4*x1 + 13*x4 <= 86)
model.addConstr(14*x0 + 4*x1 + 6*x2 + 10*x3 + 13*x4 <= 86)

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
    print("x4: ", x4.varValue)
else:
    print("No optimal solution found")
