
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="hours_worked_by_Hank")
x1 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.INTEGER, name="hours_worked_by_Jean")

# Objective function
m.setObjective(8.95*x0 + 2.52*x1, GRB.MINIMIZE)

# Constraints
m.addConstr(21*x0 + 13*x1 >= 69, "organization_score_constraint")
m.addConstr(30*x0 + 4*x1 >= 111, "likelihood_to_quit_index_constraint")
m.addConstr(27*x0 + 28*x1 >= 51, "paperwork_competence_rating_constraint")
m.addConstr(-5*x0 + 4*x1 >= 0, "linear_combination_constraint")
m.addConstr(21*x0 + 13*x1 <= 125, "upper_bound_organization_score")
m.addConstr(30*x0 + 4*x1 <= 274, "upper_bound_likelihood_to_quit_index")
m.addConstr(27*x0 + 28*x1 <= 168, "upper_bound_paperwork_competence_rating")

# Optimize
m.optimize()

if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Hank: {x0.x}")
    print(f"Hours worked by Jean: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
