
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="x1", lb=0)  # hours worked by Hank
    x2 = model.addVar(name="x2", lb=0)  # hours worked by Jean

    # Objective function
    model.setObjective(8.95 * x1 + 2.52 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(21 * x1 <= 148)
    model.addConstr(30 * x1 <= 303)
    model.addConstr(27 * x1 <= 228)
    model.addConstr(13 * x2 <= 148)
    model.addConstr(4 * x2 <= 303)
    model.addConstr(28 * x2 <= 228)
    model.addConstr(21 * x1 + 13 * x2 >= 69)
    model.addConstr(30 * x1 + 4 * x2 >= 111)
    model.addConstr(27 * x1 + 28 * x2 >= 51)
    model.addConstr(-5 * x1 + 4 * x2 >= 0)
    model.addConstr(21 * x1 + 13 * x2 <= 125)
    model.addConstr(30 * x1 + 4 * x2 <= 274)
    model.addConstr(27 * x1 + 28 * x2 <= 168)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Hank: {x1.varValue}")
        print(f"Hours worked by Jean: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
