
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x1 = m.addVar(lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY, name="milligrams_of_vitamin_A")  # Continuous
x2 = m.addVar(lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY, vtype=gp.GRB.INTEGER, name="milligrams_of_vitamin_B5")  # Integer
x3 = m.addVar(lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY, name="grams_of_protein")  # Continuous
x4 = m.addVar(lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY, name="grams_of_fat")  # Continuous

# Define the objective function
m.setObjective(9.11*x1 + 2.55*x2 + 5.21*x3 + 9.45*x4, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(8*x1 + 7*x2 + 2*x3 + 15*x4 >= 31, name="digestive_support_index_total")
m.addConstr(8*x1 + 7*x2 <= 89, name="vitamin_A_B5_digestive_support")
m.addConstr(7*x2 + 2*x3 <= 111, name="vitamin_B5_protein_digestive_support")
m.addConstr(8*x1 + 15*x4 <= 95, name="vitamin_A_fat_digestive_support")
m.addConstr(7*x2 + 15*x4 <= 94, name="vitamin_B5_fat_digestive_support")
m.addConstr(8*x1 + 7*x2 + 15*x4 <= 142, name="vitamin_A_B5_fat_digestive_support")
m.addConstr(8*x1 + 7*x2 + 2*x3 + 15*x4 <= 142, name="total_digestive_support")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of vitamin A: {x1.varValue}")
    print(f"Milligrams of vitamin B5: {x2.varValue}")
    print(f"Grams of protein: {x3.varValue}")
    print(f"Grams of fat: {x4.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
