
from gurobipy import *

# Create a new model
m = Model("optimization_problem")

# Create variables
x = {}
variables = ['chicken drumsticks', 'green beans', 'knishes', 'fruit salads', 'protein bars', 'black beans']
for i, var_name in enumerate(variables):
    if var_name == 'black beans':
        x[i] = m.addVar(vtype=GRB.CONTINUOUS, name=var_name)
    else:
        x[i] = m.addVar(vtype=GRB.INTEGER, name=var_name)


# Set objective function
obj = 2.46*x[0]**2 + 5.25*x[0]*x[1] + 4.8*x[0]*x[2] + 4.21*x[0]*x[4] + 9.49*x[1]**2 + 5.39*x[1]*x[3] + 6.9*x[1]*x[4] + 5.57*x[1]*x[5] + 1.22*x[2]**2 + 5.15*x[2]*x[3] + 2.06*x[3]**2 + 5.06*x[3]*x[5] + 7.42*x[4]**2 + 9.35*x[4]*x[5] + 2.33*x[0] + 9.27*x[1] + 6.06*x[2] + 5.93*x[4] + 1.8*x[5]

m.setObjective(obj, GRB.MINIMIZE)

# Add constraints

resource_data = {'r0': {'description': 'sourness index', 'upper_bound': 191, 'x0': 4, 'x1': 11, 'x2': 2, 'x3': 9, 'x4': 10, 'x5': 10}, 'r1': {'description': 'grams of fat', 'upper_bound': 105, 'x0': 11, 'x1': 4, 'x2': 13, 'x3': 2, 'x4': 14, 'x5': 13}, 'r2': {'description': 'dollar cost', 'upper_bound': 116, 'x0': 13, 'x1': 12, 'x2': 11, 'x3': 4, 'x4': 1, 'x5': 9}, 'r3': {'description': 'milligrams of calcium', 'upper_bound': 149, 'x0': 11, 'x1': 5, 'x2': 8, 'x3': 9, 'x4': 6, 'x5': 9}}

m.addConstr(4*x[0] + 11*x[1] + 2*x[2] + 9*x[3] + 10*x[4] + 10*x[5] <= 191, "sourness_constraint")
m.addConstr(11*x[0] + 4*x[1] + 13*x[2] + 2*x[3] + 14*x[4] + 13*x[5] <= 105, "fat_constraint")
m.addConstr(13*x[0] + 12*x[1] + 11*x[2] + 4*x[3] + 1*x[4] + 9*x[5] <= 116, "cost_constraint")
m.addConstr(11*x[0] + 5*x[1] + 8*x[2] + 9*x[3] + 6*x[4] + 9*x[5] <= 149, "calcium_constraint")



# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
    print('Obj: %g' % m.objVal)
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

