
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="grams_of_fiber")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="milligrams_of_vitamin_B3")
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="milligrams_of_iron")


    # Set objective function
    m.setObjective(4*x0 + 5*x1 + 6*x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(5*x0 + 3*x1 + 8*x2 <= 55, "c0")
    m.addConstr(3*x1 + 8*x2 >= 13, "c1")
    m.addConstr(5*x0 + 3*x1 >= 14, "c2")
    m.addConstr(5*x0 + 3*x1 + 8*x2 >= 14, "c3")
    m.addConstr(-10*x0 + 7*x2 >= 0, "c4")
    m.addConstr(-7*x1 + 9*x2 >= 0, "c5")
    m.addConstr(5*x0 + 3*x1 <= 49, "c6")
    m.addConstr(3*x1 + 8*x2 <= 51, "c7")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
