
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="grams_of_fiber", lb=0)  # No lower bound specified, assuming 0
    x2 = model.addVar(name="milligrams_of_vitamin_B3", lb=0)  # No lower bound specified, assuming 0
    x3 = model.addVar(name="milligrams_of_iron", lb=0)  # No lower bound specified, assuming 0

    # Define the objective function
    model.setObjective(4 * x1 + 5 * x2 + 6 * x3, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(5 * x1 <= 55)
    model.addConstr(3 * x2 <= 55)
    model.addConstr(8 * x3 <= 55)
    model.addConstr(3 * x2 + 8 * x3 >= 13)
    model.addConstr(5 * x1 + 3 * x2 >= 14)
    model.addConstr(5 * x1 + 3 * x2 + 8 * x3 >= 14)
    model.addConstr(-10 * x1 + 7 * x3 >= 0)
    model.addConstr(-7 * x2 + 9 * x3 >= 0)
    model.addConstr(5 * x1 + 3 * x2 <= 49)
    model.addConstr(3 * x2 + 8 * x3 <= 51)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Grams of fiber: {x1.varValue}")
        print(f"Milligrams of vitamin B3: {x2.varValue}")
        print(f"Milligrams of iron: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
