
import gurobi

# Create a new model
model = gurobi.Model()

# Define variables
x1 = model.addVar(vtype=gurobi.GRB.INTEGER, name='milligrams_of_vitamin_A')
x2 = model.addVar(vtype=gurobi.GRB.CONTINUOUS, name='milligrams_of_vitamin_B5')

# Objective function
model.setObjective(1.66 * x1**2 + 2.23 * x2**2 + 5.28 * x2, gurobi.GRB.MINIMIZE)

# Constraints
model.addConstr(20 * x1 + x2 >= 32, name='immune_support_index_min')
model.addConstr(13 * x1 + 5 * x2 >= 11, name='cardiovascular_support_index_min')
model.addConstr(5 * x1**2 - 4 * x2**2 >= 0, name='quadratic_constraint')
model.addConstr(20 * x1 + x2 <= 54, name='immune_support_index_max')
model.addConstr(13 * x1 + 5 * x2 <= 43, name='cardiovascular_support_index_max')

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print('Optimal solution found.')
    print(f'milligrams of vitamin A: {x1.varValue}')
    print(f'milligrams of vitamin B5: {x2.varValue}')
    print(f'Objective: {model.objVal}')
else:
    print('No optimal solution found.')
